<?php

namespace API\Database;

use API\Database\Classes\Middlewares\ApiKeyAuthMiddleware;
use API\Database\Classes\Middlewares\CorsMiddleware;
use API\Database\Utils\Constants;
use API\Database\Utils\Functions;

use Middlewares\TrailingSlash;

use Slim\Factory\AppFactory;

require_once '../vendor/autoload.php';

$app = AppFactory::create();

$app->setBasePath('/server/db-api');

$app->addBodyParsingMiddleware();
$app->add(new CorsMiddleware());
$app->addRoutingMiddleware();
$app->add(new TrailingSlash(false));
$app->add(new ApiKeyAuthMiddleware(Constants::API_KEYS));
$app->addErrorMiddleware(true, true, true);

$controllers = Functions::extractControllers();

foreach ($controllers as $key => $controller) {

    $className = "\\API\Database\Controllers\\" . $controller;

    (new $className())->addRoutes($app);

}

$app->run();
